/*
 *       time.c --- The Linux Intrusion Detection System Configuration Tool 
 *       (C) Huagang Xie 1999-2001 All rights reserved.
 *       EMail complaints to xie@gnuchina.org
 *
 *       This program is free software; you can redistribute it and/or modify
 *       it under the terms of the GNU General Public License as published by
 *       the Free Software Foundation; either version 2 of the License, or
 *       (at your option) any later version.
 *
 *       This program is distributed in the hope that it will be useful,
 *       but WITHOUT ANY WARRANTY; without even the implied warranty of
 *       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *       GNU General Public License for more details.
 * 
 *       You should have received a copy of the GNU General Public License
 *       along with this program; if not, write to the Free Software
 *       Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */
/* $Id: time.c,v 1.2.2.2 2005/03/28 05:42:56 xie Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include "lidstools.h"

char *
_time2str(time_t t)
{
	int hour, min;
	char *str;
	struct tm *tm;

	if (!(str = (char *) malloc(5 * (sizeof (char *)))))
		return NULL;

	hour = min = 0;
	if (t) {
		tm = localtime(&t);
		hour = tm->tm_hour;
		min = tm->tm_min;
	}

	snprintf(str, 5, "%02d%02d", hour, min);

	return str;
}

/* 
 *	convert 38700-1200,1220-1230
 *	to string 1022-1234,0000-1234 
 */
char *
time2str(time_t time[][2])
{
	int i;
	char *p, *head;

	head = p = (char *) malloc(176 * sizeof (char *));

	for (i = 0; i < LIDS_TIME_ITEM && time[i][0] != -1; i++) {
		snprintf(p, 11, "%s-%s,", _time2str(time[i][0]),
			 _time2str(time[i][1]));
		p = head + strlen(head);
	}
	head[strlen(head) - 1] = '\0';

	return head;
}

time_t
_str2time(const char *string)
{
	char str[5], str1[3];
	struct tm *t2;
	time_t t;
	int hour, min;

	if (strlen(string) != 4)
		return (-1);

	memset(str, '\0', 5);
	memset(str1, '\0', 3);
	strncpy(str, string, 4);
	strncpy(str1, str, 2);
	hour = atoi(str1);
	min = atoi(str + 2);

	t = time(&t);
	t2 = localtime(&t);

	t2->tm_hour = hour;
	t2->tm_min = min;
	t2->tm_sec = 0;

	t = mktime(t2);

	return t % (60 * 60 * 24);
}

int
str2time(char *string, time_t * time)
{
	char *p = NULL;
	p = strchr(string, '-');

	if (p == NULL)
		return -1;
	else
		*p = '\0';

	time[0] = _str2time(string);
	time[1] = _str2time(p + 1);
	if (time[0] < 0 || time[1] < 0)
		return -1;

	return 0;
}

int
str2port(char *string, time_t * port)
{
	char *p = NULL;

	if (!isdigit(string[0]))
		return -1;

	p = strchr(string, '-');
	if (p == NULL) {
		port[0] = port[1] = atoi(string);
	} else {
		*p = '\0';
		port[0] = atoi(string);
		port[1] = atoi(p + 1);
	}

	if (port[0] < 0 || port[1] < 0 || port[0] > 1024 || port[1] > 1024)
		return -1;

	return 0;
}

/*
 *
 *	type=0 convert to time
 *	type=1 convert to port
 */
int
str2data(char *string, time_t data[][2], int type, int max_item)
{
	char *p = NULL;
	char *q = NULL;
	int i = 0;
	int err = 0;

	p = string;
	if (*p == '!') {
		p++;
	}
	do {
		q = strchr(p, ',');
		if (q != NULL)
			*q = '\0';
		if (i >= max_item)
			return -2;
		if (type == 1)
			err = str2port(p, data[i]);
		else
			err = str2time(p, data[i]);
		if (err)
			return -1;
		if (data[i][0] || data[i][1])
			i++;
		p = q + 1;
	} while (q != NULL);

	if (i != max_item)
		data[i][0] = data[i][1] = -1;

	return 0;
}

/*
 *        get the time from the timestr
 */
int
lids_get_time(char *timestr, time_t data[][2])
{
	char *p = NULL;
	char *q = NULL;
	char *r = NULL;
	int i = 0;

	r = timestr;

	do {
		q = strchr(r, ',');
		if (q != NULL)
			*q = '\0';

		p = strchr(r, '-');
		if (p == NULL)
			return -1;
		*p = '\0';

		data[i][0] = atol(r);
		data[i][1] = atol(p + 1);
		i++;
		if (q != NULL)
			r = q + 1;
	} while (q != NULL && i < LIDS_TIME_ITEM);
	/* marked the laster item */
	if (i != LIDS_TIME_ITEM)
		data[i][0] = data[i][1] = -1;

	return 0;
}

/*
 *	display the data in 2323-1123,12121-121212 from time[16][2]
 *
 *  type = 0  time
 *  type = 1  port
 */

char *
disp_multi_data(time_t data[][2], int type)
{
	int j = 0, max_item;
	char *head, *p;

	p = head = malloc(14 * 16 * sizeof (char *));

	if (p == NULL)
		return NULL;
	/* if data has the same entry, disp as 0-0 ,only for time */
	memset(p, '\0', 176);

	if (type)
		max_item = LIDS_PORT_ITEM;
	else
		max_item = LIDS_TIME_ITEM;

	for (j = 0; data[j][0] != -1 && j < max_item; j++) {
		if (!type && data[j][0] == data[j][1]) {
			strncpy(head, "0-0,", 5);
			break;
		}
		/*
		   if(data[j][0] == data[j][1]) 
		   snprintf(p,14,"%d,",data[j][0]);
		   else 
		 */
		snprintf(p, 14, "%d-%d ,", (int)data[j][0], (int)data[j][1]);
		p = head + strlen(head);
	}

	head[strlen(head) - 1] = '\0';	/* get rid of the lastest "," */
	return head;
}
