/*
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
*/
/* $Id: lidstools.h,v 1.2.2.5 2005/12/14 09:58:45 xie Exp $ */

#ifndef LIDSADM_H
#define LIDSADM_H

#define LIDS_ACL_VERSION 	0x00020200

#include <limits.h>

#define LIDS_PORT_ITEM  16
#define LIDS_TIME_ITEM  2

/* LIDSTools error codes */
#define LIDS_SUCCESS            0
#define LIDS_OOM_FAIL           1
#define LIDS_OPT_FAIL           2
#define LIDS_PROG_FAIL          3
#define LIDS_FILE_FAIL          4

/* LIDStools commands */
#define LIDS_NONE               -1
#define LIDS_ADD                1
#define LIDS_DELETE             2
#define LIDS_LIST               3
#define LIDS_DELETE_ALL         4
#define LIDS_MK_PASSWD          5
#define LIDS_SWITCH             6
#define LIDS_INIT               7
#define LIDS_UPDATE             8
#define LIDS_VIEW               9
#define LIDS_EXTEND             10
#define LIDS_STATUS		11
#define LIDS_CHECK		12
#define LIDS_SCRIPT		13

#define LIDS_DELETE_FLAG   100

#define LIDS_BOOT	0
#define LIDS_POSTBOOT	1

/* File paths */
#define LIDS_LOCKS         "/proc/sys/lids/locks"

#define LIDS_GLOBAL_CAP_FILE 	"/etc/lids/lids.cap"
#define LIDS_BOOT_CAP_FILE 	"/etc/lids/lids.boot.cap"
#define LIDS_POSTBOOT_CAP_FILE 	"/etc/lids/lids.postboot.cap"
#define LIDS_SHUTDOWN_CAP_FILE 	"/etc/lids/lids.shutdown.cap"

#define LIDS_GLOBAL_LIDS_SYS_CAP_FILE 	"/etc/lids/lids.lids_sys.cap"
#define LIDS_BOOT_LIDS_SYS_CAP_FILE 	"/etc/lids/lids.boot.lids_sys.cap"
#define LIDS_POSTBOOT_LIDS_SYS_CAP_FILE 	"/etc/lids/lids.postboot.lids_sys.cap"
#define LIDS_SHUTDOWN_LIDS_SYS_CAP_FILE 	"/etc/lids/lids.shutdown.lids_sys.cap"

#define LIDS_GLOBAL_CONF_FILE	"/etc/lids/lids.conf"	/* the configuration file */
#define LIDS_BOOT_CONF_FILE	"/etc/lids/lids.boot.conf"	/* the configure boot file */
#define LIDS_POSTBOOT_CONF_FILE	"/etc/lids/lids.postboot.conf"	/* the configure boot file */
#define LIDS_SHUTDOWN_CONF_FILE	"/etc/lids/lids.shutdown.conf"	/* the configure boot file */


/* Misc macros */
#define LIDS_CONF_COMMENT  "#\n# \tThis file is auto generated by lidsconf \n#\tPlease do not modify this file by hand\n#\n"
#define LIDS_SCRIPT_HEADER  "#!/bin/sh\n#\n# \tThis file was auto generated by lidsconf \n#\tFeel free to modify this file by hand \n#\tRemove rules for anything you don't want to happen\n#\tSome pathnames are generated by 'which', not at runtime, so you need to check them\n#\tIf a pathname is missing, you need to add it\n#\n"

typedef struct lids_s {
	int type;		/* access control type */
	unsigned long int s_ino;	/* subject inode number */
	unsigned int s_dev;	/* subject dev number */
	char s_file[PATH_MAX + 1];	/* subject filename */
	unsigned long int o_ino;	/* object inode number */
	unsigned int o_dev;	/* object dev number */
	char o_file[PATH_MAX + 1];	/* object filename */
	int inherit;		/* inherit level */
	int mark;		/* netfilter mark */
	time_t time[LIDS_TIME_ITEM][2];	/* from-to time */
	time_t port[LIDS_PORT_ITEM][2];	/* bind port */
	int state;		/* STATE */
} lids_t;

extern char *disp_multi_data(time_t data[][2], int type);
extern int lids_get_time(char *timestr, time_t data[][2]);
extern int str2data(char *string, time_t data[][2], int type, int max_item);
extern int read_crypto_passwd(char *crypto_key, int type, int num);
extern int sha256(char *passwd, int len, char *result);
extern int lids_local_pid;


#endif
