#ifndef LIDSIF_H
#define LIDSIF_H

/*
 * This file contains every definitions needed for interfacing
 * kernel part and user space part of LIDS
 *
 */

/* 
 * If the file is not compiled for the kernel,
 * it must include  replacement file which contains
 * a copy of every internal structure needed 
 *
 */
#ifdef __KERNEL__
#include <linux/kdev_t.h>
#include <linux/capability.h>
#else
#include <kernel_inc.h>
#include <linux/dcache.h>
#include <limits.h>
#endif

/* 
 * Here begin the common structures, shared by LIDS and 
 * lidstools
 *
 */

#define LIDS_FLAGS_LIDS_ON            	0
#define LIDS_FLAGS_RELOAD_CONF        	1
#define LIDS_FLAGS_LIDS_LOCAL_ON      	2
#define LIDS_FLAGS_STATUS      		3
#define LIDS_FLAGS_INIT			4
#define LIDS_FLAGS_POSTBOOT		5
#define LIDS_FLAGS_SHUTDOWN		6
#define LIDS_FLAGS_ACL_DISCOVERY_ON	7

/*
 *      ACL target.
 */

#define LIDS_DENY       0	/* DENY ACCESS */
#define LIDS_READONLY   1	/* Read Only File */
#define LIDS_APPEND     2	/* APPEND ONLY FILE */
#define LIDS_WRITE      4	/* Protect Writing to device */
#define LIDS_IGNORE     8	/* Ignore the protection */
#define LIDS_CAP        16	/* acl type is capability */
#define LIDS_SOCKET	32	/* acl type is socket */
#define LIDS_SOCKET_ENABLE	33	/* acl type is socket Enable */

/*  SOCKET CAP */

#define LIDS_SOCKET_CREATE	0
#define LIDS_SOCKET_CONNECT	1
#define LIDS_SOCKET_BIND	2
#define LIDS_SOCKET_LISTEN	3
#define LIDS_SOCKET_ACCEPT	4
#define LIDS_SOCKET_SENDMSG	5
#define LIDS_SOCKET_RECVMSG	6
#define LIDS_SOCKET_GETSOCKNAME	7
#define LIDS_SOCKET_GETPEERNAME	8
#define LIDS_SOCKET_GETSOCKOPT	9
#define LIDS_SOCKET_SETSOCKOPT	10
#define LIDS_SOCKET_SHUTDOWN	11
#define LIDS_SOCKET_CREATE_TCP	12
#define LIDS_SOCKET_CREATE_UDP	13
#define LIDS_SOCKET_NF_MARK	14
#define LIDS_EXEC		15
#define LIDS_CAP_PROTECTED	16
#define LIDS_CAP_KILL_PROTECTED	17

/* LIDS STATE */
#define LIDS_STATE_GLOBAL	0
#define LIDS_STATE_BOOT		1
#define LIDS_STATE_POSTBOOT	2
#define LIDS_STATE_SHUTDOWN	3

/* CONF FILE definition */
#define LIDS_CONF_DIR "/etc/lids"

#define LIDS_PW_FILE "/etc/lids/lids.pw"
#define LIDS_PW_LEN  32

#define XATTR_NAME_LIDS "security.lids"
#define XATTR_NAME_LIDS_BOOT "security.lids.boot"
#define XATTR_NAME_LIDS_POSTBOOT "security.lids.postboot"
#define XATTR_NAME_LIDS_SHUTDOWN "security.lids.shutdown"

#define LIDS_BOOT_ACL_FILE	"/etc/lids/lids.boot.acl"	/* the acligure boot file */
#define LIDS_POSTBOOT_ACL_FILE	"/etc/lids/lids.postboot.acl"	/* the acligure boot file */
#define LIDS_SHUTDOWN_ACL_FILE	"/etc/lids/lids.shutdown.acl"	/* the acligure boot file */

#ifdef LIDS_SHRINK_SIZE
#define LIDS_BOOT_ACL_SIZEINFO_FILE   "/etc/lids/lids.boot.acl.sz"
#define LIDS_POSTBOOT_ACL_SIZEINFO_FILE       "/etc/lids/lids.postboot.acl.sz"
#define LIDS_SHUTDOWN_ACL_SIZEINFO_FILE       "/etc/lids/lids.shutdown.acl.sz"
#endif

/* 
 * Me ? Paranoiac !?
 *
 * The magic numbers are all around the encrypted password.
 * They have a null byte to bother ASCIIZ functions.
 */

#define LIDS_MAGIC   0x5344494c
#define LIDS_MAGIC_1 0x004e6741
#define LIDS_MAGIC_2 0x68002d62
#define LIDS_MAGIC_3 0xe68400c3
#define LIDS_MAGIC_4 0xd94aa400

#define LIDS_FLAG_FULL_SET            (~0)
#define LIDS_FLAG_TO_MASK(flag)       (1 << (flag))
#define lids_flag_raise(flag, bit)    ((flag) |= LIDS_FLAG_TO_MASK(bit))
#define lids_flag_lower(flag, bit)    ((flag) &= ~LIDS_FLAG_TO_MASK(bit))
#define lids_flag_raised(flag, bit)   ((flag) & LIDS_FLAG_TO_MASK(bit) & LIDS_FLAG_FULL_SET)

#define LIDS_TIME_ITEM  2
#define LIDS_PORT_ITEM  16
#define LIDS_MAX_TRY 	3
#define LIDS_TTW_FAIL	3

#define LIDS_MAX_XATTR_LEN 	8096

typedef __u32 lids_flags_t;

typedef char passwd_t[64];

typedef struct lids_locks_s {
	__u32 magic1;
	kernel_cap_t cap_bset;
	__u32 magic2;
	lids_flags_t flags;
	__u32 magic3;
	passwd_t passwd;
	__u32 magic4;
} __attribute__ ((__packed__))  lids_locks_t ;

struct lids_s_dev {
	__u32 major;
	__u32 minor;
} __attribute__ ((__packed__));

struct lids_s_inode {
	__u32 ino;
	struct lids_s_dev dev;
} __attribute__ ((__packed__));
struct lids_cap {
	int inherit;		/* this capabilities inherit level */
} __attribute__ ((__packed__));

struct lids_object_acl {
	__u32	sid;		/* subject id*/
	__u32	oid;		/* object id*/
	struct 	lids_s_inode inode;	/* point the the original inode */
	__u32 	type;		/* READ WRITE APPEND DENY  */
	__u32 	inherit;		/* the inherit level */
	struct 	lids_object_acl *next;
#ifdef __KERNEL__
	char name[64];			/* filename of the inode */
#else
	char name[PATH_MAX];			/* filename of the inode */
#endif
} __attribute__ ((__packed__)) ;

struct lids_subject_acl {
	__u32	sid;				/* sid */
	__u32 	ext_cap;			/* socket */
	__u32	sys_cap;			/* Move from tsk */
	__u32	o_acl_num;			/* the object number */
	__u32 	port[16][2];			/* bind port */
	struct lids_cap cap_inherit[32];	/* inheritable array */
	struct lids_object_acl *o_acl;		/* object acl */
} __attribute__ ((__packed__)) ;

#ifdef __KERNEL__
struct lids_task_acl {
	__u32 magic;
	struct task_struct *task;	/* back to the pointer */
	struct lids_subject_acl *s_acl;
	struct list_head list;
	spinlock_t t_lock;	/* lock */

} __attribute__ ((__packed__));
#endif
struct lids_perm {
	__u32 sid;
	__u32 oid;
	__u32 type;
} __attribute__ ((__packed__));

struct lids_inode_acl {
	__u32	magic;
	__u32 	type;			/* READ WRITE APPEND DENY  */
	__u32 	version;		/* current vesion of acl*/
	__u32	flags;			/* inode flags */
	struct lids_s_inode inode;	/* point the the original inode */
	struct lids_perm perm[64];	/* the sid/oid that have perm on this file */
	struct lids_subject_acl *s_acl;
#ifdef __KERNEL__
	char name[64];			/* filename of the inode */
#else
	char name[PATH_MAX];			/* filename of the inode */
#endif
}  __attribute__ ((__packed__)) ;
struct lids_acl_header{
	__u32 magic;		/* MAGIC */
	__u32 version;		/* ACL Version */
	__u32 sys_cap;		/* Overall Cap */
	__u32 ext_cap;		/* Overall Ext Cap */
	__u32 discovery;   	/* Discovery Mode*/
	__u32 search;   	/* Search Matrix*/
	__u32 u_size;		/* user size */
	struct lids_s_inode lidsadm; 	/* lidsadm's inode value*/
} __attribute__ ((__packed__));

#endif
